package ru.yandex.calendar.logic.event.avail.absence;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.val;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.util.json.JacksonUtils;
import ru.yandex.inside.passport.login.PassportLogin;
import ru.yandex.misc.io.InputStreamSource;

/**
 * @author akirakozov
 * https://wiki.yandex-team.ru/staff/pool/gap2/api/export_gaps/
 */
public class AbsenceParser {

    public static ListF<Absence> parse(InputStreamSource source) {
        JsonNode result = JacksonUtils.readTree(source.getInputUnchecked());

        return Cf.x(result.get("persons").fields()).flatMap(person -> {
            try {
                val login = PassportLogin.cons(person.getKey());

                return Cf.x(person.getValue().elements())
                    .map(absence -> new Absence(
                            absence.get("id").longValue(),
                            login,
                            LocalDateTime.parse(absence.get("date_from").textValue()),
                            LocalDateTime.parse(absence.get("date_to").textValue()),
                            absence.get("full_day").booleanValue(),
                            AbsenceType.byGapId(absence.get("workflow").textValue())
                                    .getOrThrow("unexpected workflow: " + absence.get("workflow").textValue()),
                            absence.get("comment").textValue(),
                            absence.get("work_in_absence").booleanValue()
                        )
                    );
            } catch (RuntimeException e) {
                throw new RuntimeException("Failed to parse absences of " + person.getKey(), e);
            }
        }).toList();
    }
}
