package ru.yandex.calendar.logic.event.avail.absence;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.NameI18n;

/**
 * @author dbrylev
 */
public enum AbsenceType {
    ABSENCE("absence", "Отсутствие", "Absence", "Отсутствия"),
    LEARNING("learning", "Обучение", "Learning", "Обучения"),
    VACATION("vacation", "Отпуск", "Vacation", "Отпуска"),
    ILLNESS("illness", "Болезнь", "Sick leave", "Болезни"),
    TRIP("trip", "Командировка", "Business trip", "Командировки"),
    CONFERENCE_TRIP("conference_trip", "Командировка на конференцию", "Conference trip", "Командировки на конференции"),
    CONFERENCE("conference", "Конференция", "Conference", "Конференции"),
    MATERNITY("maternity", "Отпуск по уходу за ребёнком", "Leave for childcare", "Отпуска по уходу за ребёнком"),
    PAID_DAY_OFF("paid_day_off", "Отгул", "Paid day off", "Отгулы"),
    DUTY("duty", "Дежурство", "Duty", "Дежурства"),
    WORK_FROM_HOME("remote_work", "Удаленная работа", "Remote Work", "Режим работы"),
    OFFICE_WORK("office_work", "Работа из офиса", "Office Work", "Режим работы"),
    ;

    private final String gapId;
    private final NameI18n eventName;
    private final String layerName;

    private static final MapF<String, AbsenceType> byGapId = Cf.x(values()).toMapMappingToKey(AbsenceType.getGapIdF());

    private static final MapF<String, AbsenceType> byEventName = Cf.toMap(Cf.x(values()).flatMap(
            new Function<AbsenceType, ListF<Tuple2<String, AbsenceType>>>() {
                public ListF<Tuple2<String, AbsenceType>> apply(AbsenceType a) {
                    return a.eventName.getAllNames().map(Tuple2.<String, AbsenceType>consF().bind2(a));
                }
            }));

    AbsenceType(String gapId, String ruEventName, String enEventName, String layerName) {
        this.gapId = gapId;
        this.eventName = new NameI18n(ruEventName, enEventName);
        this.layerName = layerName;
    }

    public static Option<AbsenceType> byGapId(String id) {
        return byGapId.getO(id);
    }

    public static Option<AbsenceType> byEventName(String name) {
        return byEventName.getO(name);
    }

    public String getGapId() {
        return gapId;
    }

    public NameI18n getEventName() {
        return eventName;
    }

    public String getLayerName() {
        return layerName;
    }

    public static Function<AbsenceType, String> getGapIdF() {
        return new Function<AbsenceType, String>() {
            public String apply(AbsenceType t) {
                return t.getGapId();
            }
        };
    }

    public static Function<AbsenceType, String> getEventNameF(final Language lang) {
        return new Function<AbsenceType, String>() {
            public String apply(AbsenceType t) {
                return t.getEventName().getName(lang);
            }
        };
    }

    public static Function<String, Option<AbsenceType>> byEventNameF() {
        return new Function<String, Option<AbsenceType>>() {
            public Option<AbsenceType> apply(String name) {
                return byEventName(name);
            }
        };
    }
}
