package ru.yandex.calendar.logic.event.dao;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.EventResourceUncheckin;
import ru.yandex.calendar.logic.beans.generated.EventResourceUncheckinFields;
import ru.yandex.calendar.logic.beans.generated.EventResourceUncheckinHelper;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;

/**
 * @author dbrylev
 */
public class EventResourceUncheckinDao extends CalendarJdbcDaoSupport {
    @Autowired
    private GenericBeanDao genericBeanDao;

    public void save(EventResourceUncheckin uncheckin) {
        genericBeanDao.insertBean(uncheckin);
    }

    public void update(EventResourceUncheckin uncheckin) {
        genericBeanDao.updateBean(uncheckin);
    }

    public Option<EventResourceUncheckin> findByMainEventIdAndResourceId(long mainEventId, long resourceId) {
        return genericBeanDao.findBeanById(EventResourceUncheckinHelper.INSTANCE, Tuple2.tuple(mainEventId, resourceId));
    }

    public void deleteByMainEventIds(ListF<Long> mainEventIds) {
        genericBeanDao.deleteBeans(EventResourceUncheckinHelper.INSTANCE,
                EventResourceUncheckinFields.MAIN_EVENT_ID.column().inSet(mainEventIds));
    }
}
