package ru.yandex.calendar.logic.event.meeting;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.EventInvitationManager;
import ru.yandex.calendar.logic.ics.exp.EventInstanceParameters;
import ru.yandex.calendar.logic.sending.EventSendingInfo;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.logic.sharing.participant.ParticipantInfo;
import ru.yandex.calendar.logic.sharing.participant.Participants;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author akirakozov
 */
public class CancelMeetingHandler {

    @Autowired
    private EventInvitationManager eventInvitationManager;

    private class Do {

        private final Event event;
        private final Option<PassportUid> uid;
        private final EventInstanceParameters icsEventExportParameters;
        private final boolean isParkingOrApartmentOccupation;
        private final ActionInfo actionInfo;
        private final boolean isExportedWithEws;

        private Do(
                Event event, Option<PassportUid> uid,
                EventInstanceParameters icsEventExportParameters,
                boolean isParkingOrApartmentOccupation, ActionInfo actionInfo, boolean isExportedWithEws)
        {
            this.event = event;
            this.uid = uid;
            this.icsEventExportParameters = icsEventExportParameters;
            this.isParkingOrApartmentOccupation = isParkingOrApartmentOccupation;
            this.actionInfo = actionInfo;
            this.isExportedWithEws = isExportedWithEws;
        }

        private Do(
                Event event, Option<PassportUid> uid, boolean isParkingOrApartmentOccupation, ActionInfo actionInfo,
                boolean isExportedWithEws)
        {
            this(event, uid, EventInstanceParameters.fromEvent(event),
                    isParkingOrApartmentOccupation, actionInfo, isExportedWithEws);
        }

        private ListF<EventSendingInfo> prepareSendingInfo() {
            ListF<EventSendingInfo> sendingInfoStore = Cf.arrayList();
            Participants participants = eventInvitationManager.getParticipantsByEventId(event.getId());

            ListF<ParticipantInfo> invitations = participants.getParticipantsSafe()
                    .filter(ParticipantInfo.isYandexUserWithSomeOfUidsF(uid).notF());

            invitations = invitations.plus(participants.getNotDeclinedSubscribers());

            if (!isParkingOrApartmentOccupation) {
                invitations = invitations.filter(ParticipantInfo.getDecisionF().andThenEquals(Decision.NO).notF());
            }

            sendingInfoStore.addAll(eventInvitationManager.prepareSendingInfoForParticipants(
                    invitations, MailType.EVENT_CANCEL, icsEventExportParameters, Option.empty(), isExportedWithEws));

            if (uid.isPresent()) {
                sendingInfoStore.addAll(eventInvitationManager.prepareSendingInfoForActorOrPrimaryLayerOwner(
                        uid.get(), participants, event, MailType.EVENT_CANCEL,
                        icsEventExportParameters, Option.empty(),
                        actionInfo.getActionSource(), isExportedWithEws));
            }

            sendingInfoStore.addAll(eventInvitationManager.createSendingInfoForResourceSubscribers(
                    participants, event, MailType.EVENT_CANCEL, icsEventExportParameters, Option.empty()));

            return sendingInfoStore;
        }
    }

    public ListF<EventSendingInfo> cancelMeeting(
            Event event, Option<PassportUid> uid,
            EventInstanceParameters icsEventExportParameters, boolean forceNoDecision,
            boolean isExportedWithEws, ActionInfo actionInfo)
    {
        return new Do(event, uid, icsEventExportParameters, forceNoDecision, actionInfo, isExportedWithEws)
                .prepareSendingInfo();
    }

    public ListF<EventSendingInfo> cancelMeeting(
            Event event, Option<PassportUid> uid, boolean forceNoDecision,
            boolean isExportedWithEws, ActionInfo actionInfo)
    {
        return new Do(event, uid, forceNoDecision, actionInfo, isExportedWithEws).prepareSendingInfo();
    }

} //~
