package ru.yandex.calendar.logic.event.meeting;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.resource.RejectedResources;
import ru.yandex.calendar.logic.sending.EventSendingInfo;

/**
 * @author yashunsky
 */
public class EventInvitationResults {
    private final ListF<EventSendingInfo> sendingInfos;
    private final RejectedResources rejectedResources;

    public static final EventInvitationResults EMPTY = new EventInvitationResults(Cf.list(), RejectedResources.EMPTY);

    public EventInvitationResults(ListF<EventSendingInfo> sendingInfos, RejectedResources rejectedResources) {
        this.sendingInfos = sendingInfos;
        this.rejectedResources = rejectedResources;
    }

    public ListF<EventSendingInfo> getSendingInfos() {
        return sendingInfos;
    }

    public RejectedResources getRejectedResources() {
        return rejectedResources;
    }
}
