package ru.yandex.calendar.logic.event.meeting;

import com.microsoft.schemas.exchange.services._2006.types.CalendarItemUpdateOperationType;

/**
 * @author dbrylev
 */
public enum ExchangeMails {
    ALL(CalendarItemUpdateOperationType.SEND_ONLY_TO_ALL),
    INVITED_AND_REMOVED(CalendarItemUpdateOperationType.SEND_ONLY_TO_CHANGED),
    NONE(CalendarItemUpdateOperationType.SEND_TO_NONE),
    ;

    private final CalendarItemUpdateOperationType forUpdate;

    ExchangeMails(CalendarItemUpdateOperationType forUpdate) {
        this.forUpdate = forUpdate;
    }

    public static ExchangeMails fromMailToAll(boolean mailToAll) {
        return mailToAll ? ALL : INVITED_AND_REMOVED;
    }

    public CalendarItemUpdateOperationType getForUpdate() {
        return forUpdate;
    }
}
