package ru.yandex.calendar.logic.event.meeting;

/**
 * @author dbrylev
 */
public enum MeetingMailRecipients {
    INVITED_AND_REMOVED,
    NOT_REJECTED_PARTICIPANTS_AND_OUTLOOKERS,
    NOT_REJECTED_PARTICIPANTS_AND_SUBSCRIBERS,
    ALL_PARTICIPANTS_AND_SUBSCRIBERS,
    ;

    public boolean isWithSubscribers() {
        return this == NOT_REJECTED_PARTICIPANTS_AND_SUBSCRIBERS || this == ALL_PARTICIPANTS_AND_SUBSCRIBERS;
    }

    public boolean isWithOutlookers() {
        return this == NOT_REJECTED_PARTICIPANTS_AND_OUTLOOKERS || isWithSubscribers();
    }

    public boolean isToAll() {
        return this == ALL_PARTICIPANTS_AND_SUBSCRIBERS;
    }
}
