package ru.yandex.calendar.logic.event.meeting;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.function.Function0;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventInvitation;
import ru.yandex.calendar.logic.beans.generated.EventLayer;
import ru.yandex.calendar.logic.contact.ContactRoutines;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.event.ActorId;
import ru.yandex.calendar.logic.event.ChangedEventInfoForMails;
import ru.yandex.calendar.logic.event.EventAndRelations;
import ru.yandex.calendar.logic.event.EventDbManager;
import ru.yandex.calendar.logic.event.EventInvitationDao;
import ru.yandex.calendar.logic.event.EventInvitationManager;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.EventUserRoutines;
import ru.yandex.calendar.logic.event.SequenceAndDtStamp;
import ru.yandex.calendar.logic.event.avail.Availability;
import ru.yandex.calendar.logic.event.dao.EventDao;
import ru.yandex.calendar.logic.event.dao.EventLayerDao;
import ru.yandex.calendar.logic.event.dao.EventUserDao;
import ru.yandex.calendar.logic.event.repetition.EventAndRepetition;
import ru.yandex.calendar.logic.ics.EventInstanceStatusInfo;
import ru.yandex.calendar.logic.ics.exp.EventInstanceParameters;
import ru.yandex.calendar.logic.resource.RejectedResources;
import ru.yandex.calendar.logic.sending.EventSendingInfo;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.sharing.EventParticipantsChangesInfo;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.logic.sharing.ParticipantChangesInfo;
import ru.yandex.calendar.logic.sharing.ReplyInfo;
import ru.yandex.calendar.logic.sharing.participant.ExternalUserParticipantInfo;
import ru.yandex.calendar.logic.sharing.participant.ParticipantData;
import ru.yandex.calendar.logic.sharing.participant.ParticipantId;
import ru.yandex.calendar.logic.sharing.participant.ParticipantInfo;
import ru.yandex.calendar.logic.sharing.participant.Participants;
import ru.yandex.calendar.logic.sharing.participant.UserParticipantInfo;
import ru.yandex.calendar.logic.sharing.participant.YandexUserParticipantInfo;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

public class UpdateMeetingHandler {
    @Autowired
    private EventInvitationManager eventInvitationManager;
    @Autowired
    private EventUserDao eventUserDao;
    @Autowired
    private EventDao eventDao;
    @Autowired
    private ContactRoutines contactRoutines;
    @Autowired
    private EventDbManager eventDbManager;
    @Autowired
    private EventUserRoutines eventUserRoutines;
    @Autowired
    private EventInvitationDao eventInvitationDao;
    @Autowired
    private EventLayerDao eventLayerDao;
    @Autowired
    private EventRoutines eventRoutines;

    private class Do {
        private final EventParticipantsChangesInfo eventParticipantsChangesInfo;
        private final ChangedEventInfoForMails changedEventInfo;
        private final ActorId updater;
        private final MeetingMailRecipients recipients;
        private final ActionInfo actionInfo;
        private final EventInstanceStatusInfo eventInstanceStatusInfo;

        private final Event event;
        private final SequenceAndDtStamp sequence;
        private final boolean isParkingOrApartmentOccupation;
        private final UpdateMode updateMode;
        private final boolean isExportedWithEws;

        private Do(Event event, SequenceAndDtStamp sequence,
                ActorId updater, ChangedEventInfoForMails changedEventInfo,
                MeetingMailRecipients recipients, boolean isParkingOrApartmentOccupation,
                EventInstanceStatusInfo eventInstanceStatusInfo, ActionInfo actionInfo,
                UpdateMode updateMode, boolean isExportedWithEws)
        {
            this.changedEventInfo = changedEventInfo;
            this.eventParticipantsChangesInfo = changedEventInfo.getChanges().getParticipantsChanges();
            this.event = event;
            this.sequence = sequence;
            this.updater = updater;
            this.recipients = recipients;
            this.isParkingOrApartmentOccupation = isParkingOrApartmentOccupation;
            this.eventInstanceStatusInfo = eventInstanceStatusInfo;
            this.actionInfo = actionInfo;
            this.updateMode = updateMode;
            this.isExportedWithEws = isExportedWithEws;
        }

        private EventInvitationResults createNewInvitations(EventAndRelations event) {
            return eventInvitationManager.createNewEventInvitations(
                    updater, eventParticipantsChangesInfo.getNewParticipants(),
                    event.getEvent(), event.getRepetition(), isParkingOrApartmentOccupation, updateMode, actionInfo);
        }

        private EventInvitationResults prepareSendingInfo() {
            ListF<EventSendingInfo> sendingInfoStore = Cf.arrayList();

            Option<EventAndRelations> eventForNewInvitations = Option.empty();

            if (eventParticipantsChangesInfo.getNewParticipants().isNotEmpty()) {
                Event eventForUpdate = eventDbManager.getEventByIdForUpdate(event.getId());

                eventForNewInvitations = Option.of(new EventAndRelations(
                        eventDbManager.getEventWithRelationsByEvent(eventForUpdate),
                        eventDbManager.getEventAndRepetitionByEvent(eventForUpdate).getRepetitionInfo()));
            }

            sendingInfoStore.addAll(removeAttendees());

            sendingInfoStore.addAll(processAlreadyInvitedGuests(eventInstanceStatusInfo));

            RejectedResources rejectedResources = RejectedResources.EMPTY;

            if (eventForNewInvitations.isPresent()) {
                EventInvitationResults eventInvitationResults = createNewInvitations(eventForNewInvitations.get());
                sendingInfoStore.addAll(eventInvitationResults.getSendingInfos());
                rejectedResources = eventInvitationResults.getRejectedResources();
            }

            sendingInfoStore.addAll(changeOrganizer());

            changeAttendeesType();

            return new EventInvitationResults(sendingInfoStore.makeReadOnly(), rejectedResources);
        }

        private ListF<EventSendingInfo> processAlreadyInvitedGuests(EventInstanceStatusInfo status) {
            boolean isFromExchangeOrMail = actionInfo.getActionSource().isFromExchangeOrMail();

            for (Tuple2<ParticipantId, ParticipantChangesInfo> t : eventParticipantsChangesInfo.getUpdatedInvitations()) {
                ParticipantId id = t._1;
                ParticipantChangesInfo info = t._2;
                UserParticipantInfo oldParticipant = info.getOldParticipantInfo();

                boolean keepOldDecision = !isFromExchangeOrMail
                        || id.getUidIfYandexUser().exists(uid -> !uid.isYandexTeamRu()) // CAL-7856
                        || oldParticipant.getDecision() != Decision.UNDECIDED;

                if (!keepOldDecision && !isParkingOrApartmentOccupation && !oldParticipant.isAutoAcceptInvitations()) {
                    ReplyInfo replyInfo = new ReplyInfo(info.getNewDecision(), "", sequence);
                    eventInvitationManager.updateUserParticipantDecision(oldParticipant, replyInfo, actionInfo, status);
                }
                if (info.nameChanged() && oldParticipant.getId().isExternalUser()) {
                    EventInvitation data = new EventInvitation();
                    data.setId(((ExternalUserParticipantInfo) oldParticipant).getInvitation().getId());
                    data.setName(t._2.getNewName());
                    eventInvitationDao.updateInvitation(data, actionInfo);
                }
            }
            if (recipients.isToAll() && !isParkingOrApartmentOccupation) {
                updateParticipantsMakeUndecided();
            }

            ListF<EventSendingInfo> sendingInfoStore = Cf.arrayList();

            Participants participants = eventInvitationManager.getParticipantsByEventId(event.getId());
            ListF<ParticipantInfo> invitations = participants.getParticipantsSafeWithInconsistent();

            if (recipients.isWithSubscribers()) {
                invitations = invitations.plus(participants.getNotDeclinedSubscribers());
            } else if (recipients.isWithOutlookers()) {
                invitations = invitations.plus(participants.getNotDeclinedOutlookerSubscribers());
            }

            if (!recipients.isToAll() && !isParkingOrApartmentOccupation) {
                invitations = invitations.filter(ParticipantInfo.getDecisionF().andThenEquals(Decision.NO).notF());
            }

            Option<ParticipantInfo> organizer = invitations.find(ParticipantInfo.isOrganizerF());
            Option<PassportUid> organizerUid = organizer.filterMap(ParticipantInfo.getUidF());

            boolean updaterIsOrganizer = organizerUid.exists(updater.getUidO().containsF());
            boolean organizerRemoved = eventParticipantsChangesInfo.getRemovedOrganizers()
                    .exists(ParticipantInfo.getUidF().andThen(Cf2.isSomeOfF(organizerUid)));

            if (!updaterIsOrganizer && !organizerRemoved) {
                sendingInfoStore.addAll(prepareSendingInfoForInvitedGuests(organizer));
            }
            if (!(updaterIsOrganizer && organizerRemoved)) {
                sendingInfoStore.addAll(prepareSendingInfoForActorOrPrimaryLayerOwner(participants));
            }
            if (eventParticipantsChangesInfo.isChangedToNotMeeting()) {
                eventParticipantsChangesInfo.getRemovedOrganizers()
                        .filterByType(YandexUserParticipantInfo.class)
                        .forEach(p -> sendingInfoStore.addAll(
                                eventInvitationManager.prepareSendingInfoForActorOrPrimaryLayerOwner(
                                p.getUidSome(), participants, event, MailType.EVENT_UPDATE,
                                EventInstanceParameters.fromEvent(event), Option.of(changedEventInfo),
                                actionInfo.getActionSource(), isExportedWithEws)));
            }

            if (recipients != MeetingMailRecipients.INVITED_AND_REMOVED) {
                sendingInfoStore.addAll(prepareSendingInfoForInvitedGuests(invitations.filter(
                        ParticipantInfo.getUidF().andThen(Cf2.isSomeOfF(organizerUid.plus(updater.getUidO())).notF()))));
            }
            sendingInfoStore.addAll(eventInvitationManager.createSendingInfoForResourceSubscribers(
                    participants, event, MailType.EVENT_UPDATE,
                    EventInstanceParameters.fromEvent(event), Option.of(changedEventInfo)));

            return sendingInfoStore;
        }

        private Option<EventSendingInfo> prepareSendingInfoForActorOrPrimaryLayerOwner(Participants participants) {
            if (!updater.isUser()) return Option.empty();

            if (!isParkingOrApartmentOccupation && participants.getByUidSafeWithInconsistent(updater.getUid())
                    .exists(ParticipantInfo.getDecisionF().andThenEquals(Decision.NO)))
            {
                return Option.empty();
            }
            return eventInvitationManager.prepareSendingInfoForActorOrPrimaryLayerOwner(
                    updater.getUid(), participants, event, MailType.EVENT_UPDATE,
                    EventInstanceParameters.fromEvent(event), Option.of(changedEventInfo),
                    actionInfo.getActionSource(), isExportedWithEws);
        }

        private ListF<EventSendingInfo> prepareSendingInfoForInvitedGuests(ListF<ParticipantInfo> participants) {
            return eventInvitationManager.prepareSendingInfoForParticipants(participants, MailType.EVENT_UPDATE,
                    EventInstanceParameters.fromEvent(event), Option.of(changedEventInfo), isExportedWithEws);
        }

        private void updateParticipantsMakeUndecided() {
            Participants participants = eventInvitationManager.getParticipantsByEventId(event.getId());
            ListF<UserParticipantInfo> invitations = participants.getUserParticipantsSafeWithInconsistent();

            Function0<EventAndRepetition> loadEventF =
                    () -> eventDbManager.getEventAndRepetitionByIdForUpdate(event.getId());
            loadEventF = loadEventF.memoize();

            for (UserParticipantInfo p : invitations) {
                if (p.getUid().exists(updater.getUidO().containsF())) continue;

                Decision decision = p.getDecision() != Decision.NO && p.isAutoAcceptInvitations()
                        ? Decision.YES
                        : actionInfo.getActionSource() == ActionSource.DISPLAY ? p.getDecision() : Decision.UNDECIDED;

                if (p.isOrganizer()) {
                    decision = Decision.YES;
                }

                eventInvitationManager.updateUserParticipantDecision(
                        p, new ReplyInfo(decision, "", sequence), actionInfo, eventInstanceStatusInfo);

                for (PassportUid uid : p.getUid()) {
                    eventUserRoutines.updateEventUserAvailability(
                            uid, event.getId(), Availability.byDecision(decision), actionInfo);
                    eventDbManager.saveEventLayerIfAbsentForUser(uid, loadEventF.apply(), actionInfo);
                }
            }
        }

        private ListF<EventSendingInfo> changeOrganizer() {
            boolean oldOrganizerLayerWasPrimary = eventDbManager.getEventLayersForEventsAndUsers(
                    Cf.list(event.getId()), eventParticipantsChangesInfo.getOldOrganizers().map(ParticipantId::getUid))
                    .exists(EventLayer::getIsPrimaryInst);

            ListF<EventSendingInfo> sendingInfos = Cf.arrayList();

            for (ParticipantInfo removed : eventParticipantsChangesInfo.getRemovedOrganizers()) {
                if (removed.isOrganizer()) {
                    if (eventParticipantsChangesInfo.isChangedToNotMeeting() && removed.isYandexUser()) {
                        eventUserDao.updateEventUserSetNotAttendeeAndNotOrganizerByEventIdAndUserId(
                                event.getId(), removed.getUid().get(), actionInfo);
                    } else {
                        sendingInfos.addAll(removeParticipant(removed));
                    }
                }
            }
            eventInvitationManager.updateParticipantsSetIsOrganizer(
                    event.getId(), eventParticipantsChangesInfo.getNewOrganizerNotJustInvited(), true, actionInfo);
            eventInvitationManager.updateParticipantsSetIsOrganizer(
                    event.getId(), eventParticipantsChangesInfo.getOldOrganizersNotRemoved(), false, actionInfo);

            if (!isParkingOrApartmentOccupation && (oldOrganizerLayerWasPrimary ||
                    !eventLayerDao.findEventLayersByEventId(event.getId()).exists(EventLayer::getIsPrimaryInst)))
            {
                makeOrganizerLayerPrimary();
            }

            return sendingInfos;
        }

        private void makeUserLayerPrimary(PassportUid uid) {
            eventLayerDao.updateNotIsPrimaryInstByEventId(event.getId());

            Option<EventLayer> existingEventLayer =
                    eventDbManager.getEventLayersForEventsAndUser(Cf.list(event.getId()), uid).firstO();

            if (existingEventLayer.isPresent()) {
                EventLayer el = existingEventLayer.get();
                EventLayer data = new EventLayer();
                data.setIsPrimaryInst(true);

                data.setEventId(el.getEventId());
                data.setLayerId(el.getLayerId());
                data.setLCreatorUid(uid);
                eventDbManager.updateEventLayer(data, actionInfo);

            } else {
                eventRoutines.attachMeetingToOrganizer(uid, event.getId(), actionInfo);
            }
        }

        private void makeOrganizerLayerPrimary() {
            Option<PassportUid> newOrganizer =
                    eventParticipantsChangesInfo.getNewOrganizer().flatMapO(ParticipantId::getUidIfYandexUser);
            if (newOrganizer.isPresent()) {
                makeUserLayerPrimary(newOrganizer.get());
                return;
            }
            eventDbManager.getEventWithRelationsByEvent(event).getParticipants()
                    .getOrganizerIdSafe().filterMap(ParticipantId::getUidIfYandexUser)
                    .forEach(this::makeUserLayerPrimary);
        }

        /**
         * @return tuple list with only user contents (no resources at all)
         */
        private ListF<EventSendingInfo> removeAttendees() {
            return eventParticipantsChangesInfo.getRemovedParticipantsButNotOrganizer()
                    .filterMap(this::removeParticipant);
        }

        private Option<EventSendingInfo> removeParticipant(ParticipantInfo participant) {
            eventInvitationManager.removeAttendeeByParticipantId(event.getId(), participant.getId(), actionInfo);

            if (!participant.isResource() && !isExportedWithEws) {
                UserParticipantInfo userParticipantInfo = (UserParticipantInfo) participant;

                if (participant.getDecision() != Decision.NO || isParkingOrApartmentOccupation) {
                    return Option.of(new EventSendingInfo(
                            userParticipantInfo, MailType.EVENT_CANCEL,
                            EventInstanceParameters.fromEvent(event), Option.empty()));
                }
            }
            return Option.empty();
        }

        private void changeAttendeesType() {
            eventParticipantsChangesInfo.getUpdatedInvitations()
                    .filter(invitation -> invitation._2.isOptionalChanged())
                    .forEach(invitation -> {
                        eventUserDao.updateEventUserSetIsOptionalByEventIdAndUid(
                                event.getId(),
                                invitation._1.getUid(),
                                invitation._2.getNewIsOptional(),
                                actionInfo
                        );
                    });
        }

    } // Do ends


    public EventInvitationResults handleMeetingUpdate(
            Event event, ActorId updater,
            ChangedEventInfoForMails changesInfo, MeetingMailRecipients recipients,
            boolean isParkingOrApartmentOccupation, ActionInfo actionInfo,
            EventInstanceStatusInfo eventInstanceStatusInfo,
            UpdateMode updateMode, boolean isExportedWithEws)
    {
        SequenceAndDtStamp sequence = new SequenceAndDtStamp(
                eventDao.findEventsByIdsSafe(Cf.list(event.getId())).singleO().getOrElse(event).getSequence(),
                actionInfo.getNow());

        EventInvitationResults r = new Do(
                event, sequence, updater, changesInfo, recipients,
                isParkingOrApartmentOccupation, eventInstanceStatusInfo, actionInfo, updateMode, isExportedWithEws)
                .prepareSendingInfo();

        if (updater.isUser()) {
            ListF<Email> emails = changesInfo.getChanges().getParticipantsChanges()
                    .getNewParticipants().get2().map(ParticipantData.getEmailF());
            contactRoutines.exportUserContactsEmails(updater.getUid(), emails);
        }

        // XXX: just generate correct event in code above
        eventInvitationManager.fixParticipants(event.getId(), actionInfo);

        return r;
    }

} //~
