package ru.yandex.calendar.logic.event.model;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.CamelWords;

/**
 * @author akirakozov
 */
public enum Completion implements StringEnum {
    NOT_APPLICABLE,
    INCOMPLETE,
    IN_PROGRESS,
    COMPLETE;

    public static final StringEnumResolver<Completion> R = StringEnumResolver.r(Completion.class);

    public String toDbValue() {
        return CamelWords.parse(this.name()).toDbName();
    }

    @Override
    public String value() {
        return toDbValue();
    }
}
