package ru.yandex.calendar.logic.event.model;

import lombok.AllArgsConstructor;
import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.email.Email;

@Value
@AllArgsConstructor
public class EventInvitationData {
    Email email;
    Option<String> name;
    boolean isOptional;

    public EventInvitationData(Email email, boolean isOptional) {
        this(email, Option.empty(), isOptional);
    }

    public EventInvitationData(Email email) {
        this(email, Option.empty(), false);
    }

    public static Function<Email, EventInvitationData> consWithNoNameF() {
        return EventInvitationData::new;
    }

    public static Function<EventInvitationData, Email> getEmailF() {
        return EventInvitationData::getEmail;
    }

    public static Function<EventInvitationData, Option<String>> getNameF() {
        return EventInvitationData::getName;
    }
}
