package ru.yandex.calendar.logic.event.model;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.email.Email;

@Getter
@AllArgsConstructor
public class EventInvitationUpdateData {
    private final Option<Email> organizerEmail;
    private final ListF<Email> newEmails;
    private final ListF<Email> remEmails;

    public static final EventInvitationUpdateData EMPTY = new EventInvitationUpdateData(Cf.list(), Cf.list());

    public EventInvitationUpdateData(ListF<Email> newEmails, ListF<Email> remEmails) {
        this(Option.empty(), newEmails, remEmails);
    }

    public ListF<Email> getAllEmails() {
        return newEmails.plus(remEmails).plus(organizerEmail).stableUnique();
    }

    public EventInvitationUpdateData plusEmail(Email email) {
        return new EventInvitationUpdateData(organizerEmail, newEmails.plus(email), remEmails);
    }

    public EventInvitationUpdateData withOrganizer(Option<Email> organizerEmail) {
        return new EventInvitationUpdateData(organizerEmail, newEmails, remEmails);
    }
}
