package ru.yandex.calendar.logic.event.model;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.misc.email.Email;

public class EventInvitationsData {
    private final Option<Email> organizerEmail;
    private final ListF<EventInvitationData> nowInvitations;

    public EventInvitationsData(
            Option<Email> organizerEmail,
            ListF<EventInvitationData> nowInvitations)
    {
        this.organizerEmail = organizerEmail;
        this.nowInvitations = nowInvitations;
    }

    public EventInvitationsData(ListF<Email> nowEmails) {
        this(Option.empty(), nowEmails.map(EventInvitationData.consWithNoNameF()));
    }

    public Option<Email> getOrganizerEmail() {
        return organizerEmail;
    }

    public ListF<EventInvitationData> getNowInvitations() {
        return nowInvitations;
    }

    public ListF<Email> getNowEmails() {
        return nowInvitations.map(EventInvitationData.getEmailF());
    }

    public ListF<Email> getNowInvitationEmailsHaveNoNames() {
        return nowInvitations.filter(EventInvitationData.getNameF().andThen(Cf2.f1B(n -> !n.isPresent())))
                .map(EventInvitationData.getEmailF());
    }

    public EventInvitationsData plusEmail(Email email) {
        return new EventInvitationsData(
                organizerEmail, nowInvitations.plus(new EventInvitationData(email)));
    }

    public EventInvitationsData withOrganizer(Option<Email> organizerEmail) {
        return new EventInvitationsData(organizerEmail, nowInvitations);
    }
}
