package ru.yandex.calendar.logic.event.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.calendar.logic.event.avail.absence.AbsenceType;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.CamelWords;

/**
 * @author ssytnik
 * @author Stepan Koltsov
 */
public enum EventType implements StringEnum {
    USER,
    SERVICE,
    FEED,

    // Absences
    ABSENCE,
    LEARNING,
    VACATION,
    ILLNESS,
    TRIP,
    CONFERENCE_TRIP,
    CONFERENCE,
    MATERNITY,
    DUTY,
    REMOTE_WORK,
    OFFICE_WORK,
    ;

    public static final StringEnumResolver<EventType> R = StringEnumResolver.r(EventType.class);

    public String toDbValue() { return CamelWords.parse(this.name()).toDbName(); }

    public static final SetF<EventType> ABSENCES = Cf.set(
            ABSENCE,
            LEARNING,
            VACATION,
            ILLNESS,
            TRIP,
            CONFERENCE_TRIP,
            CONFERENCE,
            MATERNITY,
            DUTY,
            REMOTE_WORK,
            OFFICE_WORK
    );

    public boolean isAbsence() {
        return ABSENCES.containsTs(this);
    }

    @Override
    public String value() {
        return toDbValue();
    }

    public AbsenceType toAbsenceType() {
        switch (this) {
            case ABSENCE: return AbsenceType.ABSENCE;
            case LEARNING: return AbsenceType.LEARNING;
            case VACATION: return AbsenceType.VACATION;
            case ILLNESS: return AbsenceType.ILLNESS;
            case TRIP: return AbsenceType.TRIP;
            case CONFERENCE_TRIP: return AbsenceType.CONFERENCE_TRIP;
            case CONFERENCE: return AbsenceType.CONFERENCE;
            case MATERNITY: return AbsenceType.MATERNITY;
            case DUTY: return AbsenceType.DUTY;
            case REMOTE_WORK: return AbsenceType.WORK_FROM_HOME;
            case OFFICE_WORK: return AbsenceType.OFFICE_WORK;
        }
        throw new IllegalArgumentException();
    }
}
