package ru.yandex.calendar.logic.event.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.beans.generated.EventUserFields;
import ru.yandex.calendar.logic.notification.Notification;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.misc.lang.Validate;

public class EventUserData {
    private final EventUser eventUser;
    private final ListF<Notification> notifications;

    public EventUserData(EventUser eventUser, ListF<Notification> notifications) {
        Validate.isTrue(!eventUser.isFieldSet(EventUserFields.ID));
        this.eventUser = eventUser;
        this.notifications = notifications;
    }

    public EventUserData() {
        this(new EventUser(), Cf.list());
    }

    public EventUser getEventUser() {
        return eventUser;
    }

    public ListF<Notification> getNotifications() {
        return notifications;
    }

    public Option<Decision> getDecision() {
        return eventUser.getFieldValueO(EventUserFields.DECISION);
    }

    public EventUserData withIsAttendee(boolean isAttendee) {
        EventUser newEventUser = eventUser.copy();
        newEventUser.setIsAttendee(isAttendee);
        return new EventUserData(newEventUser, notifications);
    }

    public EventUserData withEventUser(EventUser eventUser) {
        return new EventUserData(eventUser, this.notifications);
    }
}
