package ru.yandex.calendar.logic.event.model;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.EventUser;

/**
 * @author dbrylev
 */
public class EventUserUpdate {
    public final Option<EventUser> old;
    public final Option<EventUser> cur;

    public EventUserUpdate(Option<EventUser> old, Option<EventUser> cur) {
        this.old = old;
        this.cur = cur;
    }

    public static EventUserUpdate update(EventUser old, EventUser data) {
        EventUser updated = old.copy();
        updated.setFields(data.getFieldValues());

        return new EventUserUpdate(Option.of(old), Option.of(updated));
    }

    public static EventUserUpdate empty() {
        return new EventUserUpdate(Option.empty(), Option.empty());
    }
}
