package ru.yandex.calendar.logic.event.model;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.sharing.participant.ParticipantData;
import ru.yandex.calendar.logic.sharing.participant.ParticipantsData;
import ru.yandex.misc.email.Email;

public class ParticipantsOrInvitationsData {
    private final Option<ParticipantsData> participantsData;
    private final Option<EventInvitationUpdateData> eventInvitationUpdateData;
    private final Option<EventInvitationsData> eventInvitationData;

    private final boolean makePseudoLocalCopy; // CAL-7933

    private ParticipantsOrInvitationsData(
            Option<EventInvitationsData> eventInvitationData,
            Option<EventInvitationUpdateData> eventInvitationUpdateData,
            Option<ParticipantsData> participantsData,
            boolean makePseudoLocalCopy)
    {
        this.eventInvitationData = eventInvitationData;
        this.eventInvitationUpdateData = eventInvitationUpdateData;
        this.participantsData = participantsData;
        this.makePseudoLocalCopy = makePseudoLocalCopy;
    }

    public static ParticipantsOrInvitationsData participantsData(ParticipantsData data) {
        return new ParticipantsOrInvitationsData(Option.empty(), Option.empty(), Option.of(data), false);
    }

    public static ParticipantsOrInvitationsData eventInvitationUpdateData(EventInvitationUpdateData data) {
        return new ParticipantsOrInvitationsData(Option.empty(), Option.of(data), Option.empty(), false);
    }

    public static ParticipantsOrInvitationsData eventInvitationData(EventInvitationsData data) {
        return new ParticipantsOrInvitationsData(Option.of(data), Option.empty(), Option.empty(), false);
    }

    public ParticipantsOrInvitationsData withMakePseudoLocalCopy() {
        return new ParticipantsOrInvitationsData(eventInvitationData, eventInvitationUpdateData, participantsData, true);
    }

    public ListF<Email> getParticipantEmails() {
        if (participantsData.isPresent()) {
            return participantsData.get().getParticipantsSafe().map(ParticipantData.getEmailF());
        } else if (eventInvitationUpdateData.isPresent()) {
            return eventInvitationUpdateData.get().getAllEmails();
        } else {
            return eventInvitationData.get().getNowEmails().plus(eventInvitationData.get().getOrganizerEmail());
        }
    }

    public ParticipantsOrInvitationsData plusEmail(Email email) {
        if (participantsData.isPresent()) {
            return ParticipantsOrInvitationsData.participantsData(
                    participantsData.get().plusAttendee(email, Decision.UNDECIDED));
        } else if (eventInvitationUpdateData.isPresent()) {
            return ParticipantsOrInvitationsData.eventInvitationUpdateData(
                    eventInvitationUpdateData.get().plusEmail(email));
        } else {
            return ParticipantsOrInvitationsData.eventInvitationData(
                    eventInvitationData.get().plusEmail(email));
        }
    }

    public Option<Email> getOrganizerEmail() {
        if (participantsData.isPresent()) {
            return participantsData.get().getOrganizerEmailSafe();
        } else if (eventInvitationUpdateData.isPresent()) {
            return eventInvitationUpdateData.get().getOrganizerEmail();
        } else {
            return eventInvitationData.get().getOrganizerEmail();
        }
    }

    public boolean isParticipantsData() {
        return participantsData.isPresent();
    }

    public boolean isEventInvitationUpdateData() {
        return eventInvitationUpdateData.isPresent();
    }

    public ParticipantsData getParticipantsData() {
        return participantsData.get();
    }

    public EventInvitationUpdateData getEventInvitationUpdateData() {
        return eventInvitationUpdateData.get();
    }

    public EventInvitationsData getEventInvitationsData() {
        return eventInvitationData.get();
    }

    public Option<ParticipantsData> getParticipantsDataO() {
        return participantsData;
    }

    public boolean isMakePseudoLocalCopy() {
        return makePseudoLocalCopy;
    }

    public ParticipantsOrInvitationsData withOrganizerIfInvitation(Option<Email> organizerEmail) {
        if (eventInvitationUpdateData.isPresent()) {
            return ParticipantsOrInvitationsData.eventInvitationUpdateData(
                    eventInvitationUpdateData.get().withOrganizer(organizerEmail));
        } else if (eventInvitationData.isPresent()) {
            return ParticipantsOrInvitationsData.eventInvitationData(
                    eventInvitationData.get().withOrganizer(organizerEmail));
        }
        return this;
    }
}
