package ru.yandex.calendar.logic.event.model;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.CamelWords;
import ru.yandex.misc.lang.Validate;

/**
 * @author akirakozov
 */
public enum Priority implements StringEnum {
    LOW(net.fortuna.ical4j.model.property.Priority.LOW),
    NORMAL(net.fortuna.ical4j.model.property.Priority.MEDIUM),
    HIGH(net.fortuna.ical4j.model.property.Priority.HIGH);

    private net.fortuna.ical4j.model.property.Priority icalPriority;

    private Priority(net.fortuna.ical4j.model.property.Priority icalPriority) {
        this.icalPriority = icalPriority;
    }

    // XXX CAL-2453 undefined priority should be a separate enum value
    public static Option<Priority> findByIcalPriority(
            net.fortuna.ical4j.model.property.Priority icalPriority)
    {
        if (icalPriority == null) {
            return Option.empty();
        }
        int level = icalPriority.getLevel();
        Validate.isTrue(level >= 0 && level <= 9);
        return (
            level == 0 ? Option.<Priority>empty() :
            Option.of(level < 5 ? HIGH : level > 5 ? LOW : NORMAL)
        );
    }

    public static final StringEnumResolver<Priority> R = StringEnumResolver.r(Priority.class);

    public net.fortuna.ical4j.model.property.Priority toIcalPriority() {
        return icalPriority;
    }

    public String toDbValue() {
        return CamelWords.parse(this.name()).toDbName();
    }

    @Override
    public String value() {
        return toDbValue();
    }
}
