package ru.yandex.calendar.logic.event.model;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.avail.Availability;
import ru.yandex.calendar.logic.notification.NotificationsData;
import ru.yandex.calendar.logic.sharing.Decision;

/**
 * @author dbrylev
 */
public class WebReplyData {
    private final Decision decision;
    private final Option<String> reason;
    private final Option<Long> layerId;
    private final Option<Availability> availability;
    private final NotificationsData.Create notifications;

    public WebReplyData(
            Decision decision, Option<String> reason, Option<Long> layerId,
            Option<Availability> availability, NotificationsData.Create notifications)
    {
        this.decision = decision;
        this.reason = reason;
        this.layerId = layerId;
        this.availability = availability;
        this.notifications = notifications;
    }

    public WebReplyData(Decision decision, Option<Long> layerId, NotificationsData.Create notifications) {
        this(decision, Option.<String>empty(), layerId, Option.<Availability>empty(), notifications);
    }

    public WebReplyData(Decision decision) {
        this(decision, Option.<Long>empty(), NotificationsData.useLayerDefaultIfCreate());
    }

    public Decision getDecision() {
        return decision;
    }

    public Option<String> getReason() {
        return reason;
    }

    public Option<Long> getLayerId() {
        return layerId;
    }

    public Option<Availability> getAvailability() {
        return availability;
    }

    public NotificationsData.Create getNotifications() {
        return notifications;
    }
}
