package ru.yandex.calendar.logic.event.reminders;

import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.parse.simpleType.SimpleTypeUnmarshallerSupport;

/**
 * @author dbrylev
 */
public class RemindersBender {

    public static final BenderMapper mapper = new BenderMapper(getConfiguration());

    public static BenderConfiguration getConfiguration() {
        return BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false,
                CustomMarshallerUnmarshallerFactoryBuilder.cons()
                        .add(DateTime.class, new DateTimeUnmarshaller())
                        .build());
    }

    private static class DateTimeUnmarshaller extends SimpleTypeUnmarshallerSupport {
        protected Object convert(String o) {
            return ISODateTimeFormat.dateTimeNoMillis().withOffsetParsed().parseDateTime(o);
        }
    }

}
