package ru.yandex.calendar.logic.event.reminders;

import java.util.concurrent.TimeUnit;

import javax.annotation.PreDestroy;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.lang.ObjectUtils;

/**
 * @author dbrylev
 */
public class RemindersClient {

    private final ApacheHttpClient4 httpClient = ApacheHttpClient4.newInstance(Timeout.timeout(5, TimeUnit.SECONDS), 100);

    @Value("${reminders.url:-}")
    private String remindersUrl;

    public ListF<RemindersEventInfo> findEvents(PassportUid uid, LocalDate from, LocalDate till, DateTimeZone tz) {
        byte[] response = httpClient.get(url("find-events", "uid", uid, "from", from, "till", till, "tz", tz));
        return RemindersBender.mapper.parseJson(FindEventsResponse.class, response).getEvents();
    }

    public void deleteEvent(PassportUid uid, String clientId, String externalId, long idx) {
        byte[] response = httpClient.get(
                url("delete-event", "uid", uid, "clientId", clientId, "externalId", externalId, "idx", idx));
        Check.equals("ok", RemindersBender.mapper.parseJson(DeleteEventResponse.class, response).getStatus());
    }

    private String url(String action, Object... nameValue) {
        Tuple2List<String, String> params = Tuple2List.fromPairs(nameValue)
                .map1(ObjectUtils::toString)
                .map2(ObjectUtils::toString);

        return remindersUrl + "/calendar/" + action + "?" + UrlUtils.listMapToUrlParameters(params);
    }

    @PreDestroy
    public void close() {
        httpClient.stop();
    }
}
