package ru.yandex.calendar.logic.event.reminders;

import org.joda.time.DateTime;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class RemindersEventInfo {
    private String clientId;
    private String externalId;
    private long idx;

    private DateTime start;

    private String name;
    private Option<String> description;
    private ListF<String> reminderChannels;

    public String getClientId() {
        return clientId;
    }

    public String getExternalId() {
        return externalId;
    }

    public long getIdx() {
        return idx;
    }

    public DateTime getStart() {
        return start;
    }

    public String getName() {
        return name;
    }

    public Option<String> getDescription() {
        return description;
    }

    public ListF<String> getReminderChannels() {
        return reminderChannels;
    }
}
