package ru.yandex.calendar.logic.event.repetition;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.event.EventIndent;
import ru.yandex.calendar.logic.event.EventInterval;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class EventIndentAndRepetition {

    private final EventIndent indent;
    private final RepetitionInstanceInfo repetitionInfo;

    public EventIndentAndRepetition(EventIndent indent, RepetitionInstanceInfo repetitionInfo) {
        Validate.equals(new InstantInterval(indent.getStart(), indent.getEnd()), repetitionInfo.getEventInterval());
        this.indent = indent;
        this.repetitionInfo = repetitionInfo;
    }

    public static EventIndentAndRepetition fromEventAndRepetition(Event event, RepetitionInstanceInfo repetitionInfo) {
        EventIndent indent;
        if (repetitionInfo.getRepetition().isPresent()) {
            indent = new EventIndent.Repeating(
                    event.getId(), event.getMainEventId(),
                    event.getStartTs(), event.getEndTs(), event.getIsAllDay(),
                    repetitionInfo.getRepetition().get(), repetitionInfo.getTz().getID(), 0);
        } else {
            indent = new EventIndent.Single(
                    event.getId(), event.getMainEventId(), event.getStartTs(), event.getEndTs(),
                    event.getRecurrenceId(), event.getIsAllDay(), repetitionInfo.getTz().getID(), 0);
        }
        return new EventIndentAndRepetition(indent, repetitionInfo);
    }

    public long getEventId() {
        return indent.getEventId();
    }

    public EventIndent getIndent() {
        return indent;
    }

    public RepetitionInstanceInfo getRepetitionInfo() {
        return repetitionInfo;
    }

    public EventInterval getEventInterval(InstantInterval interval) {
        return new EventIndentInterval(this, interval).getEventInterval();
    }

    public ListF<EventIndentInterval> getInstancesInInterval(InfiniteInterval interval) {
        ListF<InstantInterval> intervals = RepetitionUtils.getInstancesInInterval(repetitionInfo, interval);

        return intervals.map(EventIndentInterval.consF(this));
    }

    public static Function1B<EventIndentAndRepetition> hasZeroLengthF() {
        return e -> e.getRepetitionInfo().getEventInterval().isEmpty();
    }

    public static Function<EventIndentAndRepetition, ListF<EventIndentInterval>>
            getInstancesInIntervalF(InstantInterval interval)
    {
        return getInstancesInIntervalF(new InfiniteInterval(interval.getStart(), Option.of(interval.getEnd())));
    }

    public static Function<EventIndentAndRepetition, ListF<EventIndentInterval>>
            getInstancesInIntervalF(InfiniteInterval interval)
    {
        return e -> e.getInstancesInInterval(interval);
    }
}
