package ru.yandex.calendar.logic.event.repetition;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.event.EventIndent;
import ru.yandex.calendar.logic.sharing.perm.EventInfoForPermsCheck;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class EventIndentAndRepetitionAndPerms {

    private final EventIndentAndRepetition indent;
    private final EventInfoForPermsCheck permInfo;

    public EventIndentAndRepetitionAndPerms(EventIndentAndRepetition indent, EventInfoForPermsCheck permInfo) {
        this.indent = indent;
        this.permInfo = permInfo;
    }

    public long getEventId() {
        return indent.getEventId();
    }

    public EventIndent getIndent() {
        return indent.getIndent();
    }

    public RepetitionInstanceInfo getRepetitionInfo() {
        return indent.getRepetitionInfo();
    }

    public EventIndentAndRepetition getIndentAndRepetition() {
        return indent;
    }

    public EventInfoForPermsCheck getPermInfo() {
        return permInfo;
    }

    public ListF<EventIndentIntervalAndPerms> getInstancesInInterval(InfiniteInterval interval) {
        ListF<InstantInterval> intervals = RepetitionUtils.getInstancesInInterval(indent.getRepetitionInfo(), interval);

        return intervals.map(EventIndentIntervalAndPerms.consF(this));
    }

}
