package ru.yandex.calendar.logic.event.repetition;

import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.calendar.logic.event.EventDateTime;
import ru.yandex.calendar.logic.event.EventIndent;
import ru.yandex.calendar.logic.event.EventInterval;
import ru.yandex.calendar.logic.event.IntervalComparator;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class EventIndentInterval {
    public static final Comparator<EventIndentInterval> comparator =
            Cf2.f(EventIndentInterval::getInterval).andThen(IntervalComparator.INSTANCE)
                    .thenComparing(Cf2.f(EventIndentInterval::getEventId).andThenNaturalComparator());

    private final EventIndentAndRepetition indentAndRepetition;
    private final InstantInterval interval;

    public EventIndentInterval(EventIndentAndRepetition indentAndRepetition, InstantInterval interval) {
        this.indentAndRepetition = indentAndRepetition;
        this.interval = interval;
    }

    public EventInterval getEventInterval() {
        return new EventInterval(
                interval.getStart(),
                getEventDateTime(interval.getStart()),
                getEventDateTime(interval.getEnd()));
    }

    private EventDateTime getEventDateTime(Instant startOrEnd) {
        return indentAndRepetition.getIndent().isAllDay()
                ? EventDateTime.date(new LocalDate(startOrEnd, indentAndRepetition.getIndent().getTz()))
                : EventDateTime.dateTime(startOrEnd);
    }

    public long getEventId() {
        return indentAndRepetition.getIndent().getEventId();
    }

    public EventIndent getIndent() {
        return indentAndRepetition.getIndent();
    }

    public EventIndentAndRepetition getIndentAndRepetition() {
        return indentAndRepetition;
    }

    public InstantInterval getInterval() {
        return interval;
    }

    public static Function<InstantInterval, EventIndentInterval> consF(EventIndentAndRepetition event) {
        return interval -> new EventIndentInterval(event, interval);
    }
}
