package ru.yandex.calendar.logic.event.repetition;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.event.EventIndent;
import ru.yandex.calendar.logic.event.EventInterval;
import ru.yandex.calendar.logic.sharing.perm.EventInfoForPermsCheck;
import ru.yandex.misc.time.InstantInterval;

public class EventIndentIntervalAndPerms {
    private final EventIndentInterval indentInterval;
    private final EventInfoForPermsCheck permInfo;

    public EventIndentIntervalAndPerms(EventIndentInterval indentInterval, EventInfoForPermsCheck permInfo) {
        this.indentInterval = indentInterval;
        this.permInfo = permInfo;
    }

    public long getEventId() {
        return indentInterval.getEventId();
    }

    public EventInterval getEventInterval() {
        return indentInterval.getEventInterval();
    }

    public EventIndentInterval getIndentInterval() {
        return indentInterval;
    }

    public EventIndent getIndent() {
        return indentInterval.getIndent();
    }

    public EventIndentAndRepetitionAndPerms getIndentAndRepetitionAndPerms() {
        return new EventIndentAndRepetitionAndPerms(indentInterval.getIndentAndRepetition(), permInfo);
    }

    public static Function<InstantInterval, EventIndentIntervalAndPerms> consF(EventIndentAndRepetitionAndPerms event) {
        return interval -> new EventIndentIntervalAndPerms(
                new EventIndentInterval(event.getIndentAndRepetition(), interval), event.getPermInfo());
    }
}
