package ru.yandex.calendar.logic.event.repetition;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.time.InstantInterval;

/**
 * Interval with infinity possible infinity right bound.
 * @author akirakozov
 * @see InstantInterval
 */
public class InfiniteInterval extends DefaultObject {
    private final Instant start;
    private final Option<Instant> end;

    public InfiniteInterval(Instant start, Option<Instant> end){
        this.start = start;
        this.end = end;
    }

    public Instant getStart() {
        return start;
    }

    public Option<Instant> getEnd() {
        return end;
    }

    public boolean contains(Instant instant) {
        if (instant.isBefore(start)) {
            return false;
        }
        return !end.isPresent() || instant.isBefore(end.get());
    }

    public boolean overlaps(InstantInterval interval) {
        return interval.getEnd().isAfter(start) && (!end.isPresent() || end.get().isAfter(interval.getStart()));
    }

    @Override
    public String toString() {
        return start + "/" + end.map(Cf.Object.toStringF()).getOrElse("infty");
    }

}
