package ru.yandex.calendar.logic.event.repetition;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class IntersectingIntervals {
    private final InstantInterval firstInterval;
    private final InstantInterval secondInterval;

    public IntersectingIntervals(InstantInterval firstInterval, InstantInterval secondInterval) {
        this.firstInterval = firstInterval;
        this.secondInterval = secondInterval;
    }

    public InstantInterval getFirstInterval() {
        return firstInterval;
    }

    public InstantInterval getSecondInterval() {
        return secondInterval;
    }

    public InstantInterval getOverlap() {
        return firstInterval.overlap(secondInterval);
    }

    public static Function<IntersectingIntervals, InstantInterval> getOverlapF() {
        return new Function<IntersectingIntervals, InstantInterval>() {
            public InstantInterval apply(IntersectingIntervals is) {
                return is.getOverlap();
            }
        };
    }
}
