package ru.yandex.calendar.logic.event.repetition;

import java.util.List;
import java.util.Set;

import lombok.Value;
import lombok.val;
import one.util.streamex.StreamEx;
import org.joda.time.Instant;

import ru.yandex.calendar.logic.beans.generated.Rdate;

import static java.util.Collections.emptyList;
import static java.util.Collections.emptySet;

/**
 * Stores information about invitation changes
 */
@Value
public class RdateChangesInfo {
    List<Rdate> newRdates; // new rdates for enter into database
    Set<Long> remRdateIds; // rdate ids for removing

    public static final RdateChangesInfo EMPTY = new RdateChangesInfo(emptyList(), emptySet());

    public RdateChangesInfo withNewExdate(Instant start) {
        Rdate exdate = RepetitionUtils.consExdate(start);

        val rdates = StreamEx.of(newRdates).filter(Rdate::getIsRdate).toImmutableList();
        val exdatesAndRdates = StreamEx.of(newRdates)
                .remove(Rdate::getIsRdate)
                .append(exdate)
                .distinct(Rdate::getStartTs)
                .append(rdates)
                .toImmutableList();

        return new RdateChangesInfo(exdatesAndRdates, remRdateIds);
    }

    public boolean wasChange() {
        return !(newRdates.isEmpty() && remRdateIds.isEmpty());
    }

    public RdateChangesInfo withoutDeleted() {
        return new RdateChangesInfo(newRdates, emptySet());
    }
}
