package ru.yandex.calendar.logic.event.repetition;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.RepetitionConfirmation;
import ru.yandex.calendar.logic.beans.generated.RepetitionConfirmationFields;
import ru.yandex.calendar.logic.beans.generated.RepetitionConfirmationHelper;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;

/**
 * @author dbrylev
 */
public class RepetitionConfirmationDao extends CalendarJdbcDaoSupport {

    @Autowired
    private GenericBeanDao genericBeanDao;

    public ListF<RepetitionConfirmation> findRepetitionConfirmationsByMainEventIds(ListF<Long> mainEventIds) {
        return genericBeanDao.loadBeans(
                RepetitionConfirmationHelper.INSTANCE,
                RepetitionConfirmationFields.MAIN_EVENT_ID.column().inSet(mainEventIds));
    }

    public void findRepetitionConfirmationsQueriedBefore(Instant before, Function1V<RepetitionConfirmation> callback) {
        genericBeanDao.loadBeans(
                RepetitionConfirmationHelper.INSTANCE,
                RepetitionConfirmationFields.NEXT_QUERY_TS.lt(before),
                RepetitionConfirmationFields.NEXT_QUERY_TS,
                1, callback.compose(Cf.List.singleF()).asFunctionReturnValue(Cf.list()));
    }

    public void replaceRepetitionConfirmation(RepetitionConfirmation confirmation) {
        replaceRepetitionConfirmations(Cf.list(confirmation));
    }

    public void replaceRepetitionConfirmations(ListF<RepetitionConfirmation> confirmations) {
        genericBeanDao.upsertBeans(confirmations);
    }

    public void updateRepetitionConfirmationNextQueryTsByIdAndNextQueryTs(Instant newTs, long id, Instant oldTs) {
        RepetitionConfirmation data = new RepetitionConfirmation();
        data.setNextQueryTs(newTs);

        genericBeanDao.updateBeans(data, RepetitionConfirmationFields.MAIN_EVENT_ID.eq(id)
                .and(RepetitionConfirmationFields.NEXT_QUERY_TS.eq(oldTs)));
    }

    public void deleteRepetitionConfirmationByMainEventId(long mainEventId) {
        deleteRepetitionConfirmationsByMainEventIds(Cf.list(mainEventId));
    }

    public void deleteRepetitionConfirmationsByMainEventIds(ListF<Long> mainEventIds) {
        genericBeanDao.deleteBeans(
                RepetitionConfirmationHelper.INSTANCE,
                RepetitionConfirmationFields.MAIN_EVENT_ID.column().inSet(mainEventIds));
    }
}
