package ru.yandex.calendar.logic.event.repetition;

import ru.yandex.calendar.CalendarException;
import ru.yandex.calendar.frontend.ews.imp.ExchangeEventDataConverter;
import ru.yandex.calendar.logic.ics.imp.IcsEventDataConverter;

/**
 * Indicates that incoming repetition rule is not supported by the calendar
 * @see {@link ExchangeEventDataConverter}
 * @see {@link IcsEventDataConverter}
 * @author ssytnik
 */
@SuppressWarnings("serial")
public class UnsupportedRepetitionException extends CalendarException {

    public UnsupportedRepetitionException() {
    }

    public UnsupportedRepetitionException(String message) {
        super(message);
    }

    public UnsupportedRepetitionException(Throwable cause) {
        super(cause);
    }

    public UnsupportedRepetitionException(String message, Throwable cause) {
        super(message, cause);
    }
}
