package ru.yandex.calendar.logic.event.web;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Option;

/**
 * @author dbrylev
 */
public class IdOrExternalId {
    private final Either<Long, String> idOrExternalId;

    private IdOrExternalId(Either<Long, String> idOrExternalId) {
        this.idOrExternalId = idOrExternalId;
    }

    public static IdOrExternalId id(long id) {
        return fromOptions(Option.of(id), Option.empty());
    }

    public static IdOrExternalId externalId(String externalId) {
        return fromOptions(Option.empty(), Option.of(externalId));
    }

    public static IdOrExternalId fromOptions(Option<Long> maybeId, Option<String> maybeExternalId) {
        return new IdOrExternalId(Either.fromOptions(maybeId, maybeExternalId));
    }

    public boolean isExternal() {
        return idOrExternalId.isRight();
    }

    public long getId() {
        return idOrExternalId.getLeft();
    }

    public String getExternalId() {
        return idOrExternalId.getRight();
    }
}
