package ru.yandex.calendar.logic.event.web;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventLayer;
import ru.yandex.calendar.logic.event.EventInstanceForUpdate;
import ru.yandex.calendar.logic.event.repetition.EventAndRepetition;
import ru.yandex.calendar.logic.notification.EventUserWithNotifications;
import ru.yandex.misc.time.InstantInterval;

@AllArgsConstructor
public class ModificationItem {
    @Getter public final EventInstanceForUpdate instance;
    public final Option<Event> master;

    public boolean isRecurrence() {
        return instance.getEvent().getRecurrenceId().isPresent();
    }

    public boolean isMaster() {
        return !isRecurrence();
    }

    public boolean isRepeated() {
        return master.isPresent() && (isRecurrence() || !instance.getRepetitionInstanceInfo().isEmpty());
    }

    public Option<Instant> instanceStart() {
        return instance.getInterval().map(InstantInterval::getStart);
    }

    public String getExternalId() {
        return instance.getEventWithRelations().getExternalId();
    }

    public Event event() {
        return instance.getEvent();
    }

    public Option<EventLayer> getEventLayer() {
        return instance.getEventLayer();
    }

    public Option<EventUserWithNotifications> getEventUserNotificationPair() {
        return instance.getEventUserWithNotifications();
    }

    public EventAndRepetition getEventAndRepetition() {
        return new EventAndRepetition(instance.getEvent(), instance.getRepetitionInstanceInfo());
    }

    public ModificationItem withEmptyInterval() {
        return new ModificationItem(instance.withEmptyInterval(), master);
    }

    public ModificationItem withIntervalInsteadOfRecurrence(Instant start) {
        return new ModificationItem(instance.withIntervalInsteadOfRecurrence(start), master);
    }
}
