package ru.yandex.calendar.logic.event.web;


/**
 * @author Stepan Koltsov
 */
public enum ModificationSituation {
    SINGLE_EVENT(ModificationScope.SINGLE),
    MAIN_INST_AND_FUTURE(ModificationScope.ALL),
    THIS_AND_FUTURE(ModificationScope.ALL),
    SINGLE_INST(ModificationScope.SINGLE),
    RECURRENCE_INST(ModificationScope.SINGLE),
    ;
    private final ModificationScope direction;

    ModificationSituation(ModificationScope direction) {
        this.direction = direction;
    }

    public ModificationScope toDirection() {
        return direction;
    }

    public boolean isInstNotFuture() {
        return RECURRENCE_INST == this || SINGLE_INST == this;
    }

    public boolean isMainAndFuture() {
        return MAIN_INST_AND_FUTURE == this;
    }

    public boolean isEntire() {
        return MAIN_INST_AND_FUTURE == this || SINGLE_EVENT == this;
    }

    public boolean isSingle() {
        return ModificationScope.SINGLE == toDirection();
    }

} //~
