package ru.yandex.calendar.logic.event.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.ActorId;
import ru.yandex.calendar.logic.user.UserInfo;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author dbrylev
 */
public class UserOrYaCalendar {
    private final Option<UserInfo> userInfo;

    private UserOrYaCalendar(Option<UserInfo> userInfo) {
        this.userInfo = userInfo;
    }

    public static UserOrYaCalendar user(UserInfo userInfo) {
        return new UserOrYaCalendar(Option.of(userInfo));
    }

    public static UserOrYaCalendar yaCalendar() {
        return new UserOrYaCalendar(Option.<UserInfo>empty());
    }

    public UserInfo getUserInfo() {
        return userInfo.getOrThrow("ya-calendar");
    }

    public Option<PassportUid> getUidO() {
        return userInfo.map(UserInfo.getUidF());
    }

    public Option<UserInfo> getUserInfoO() {
        return userInfo;
    }

    public boolean isUser() {
        return userInfo.isPresent();
    }

    public boolean isYaCalendar() {
        return !userInfo.isPresent();
    }

    public ActorId toActorId() {
        return userInfo.isPresent() ? ActorId.user(userInfo.get().getUid()) : ActorId.yaCalendar();
    }
}
