package ru.yandex.calendar.logic.holiday;

import org.jdom.Element;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.grid.GrayedWeekNoAppender;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.commune.holidays.DayInfo;
import ru.yandex.commune.holidays.DayInfoHandler;

/**
 * @author akirakozov
 */
public class XmlDayInfoHandler extends DayInfoHandler {
    private Element rootElement;

    private final boolean fillDetails;
    private final boolean outLabels;
    private final Option<GrayedWeekNoAppender> grayerWeekNoAppenderO;

    public XmlDayInfoHandler(boolean fillDetails, boolean outLabels, Option<GrayedWeekNoAppender> grWnAppenderO) {
        rootElement = new Element("days");
        this.fillDetails = fillDetails;
        this.outLabels = outLabels;
        this.grayerWeekNoAppenderO = grWnAppenderO;
    }

    @Override
    public void handle(LocalDate localDate, DayInfo dayInfo) {
        Element eDay = new Element("day");
        CalendarXmlizer.setAttr(eDay, "date", localDate);
        // NOTE: no condition here (unlike in uiGetEvents)
        CalendarXmlizer.setAttr(eDay, "is-holiday", dayInfo.isDayOff());

        if (fillDetails) {
            CalendarXmlizer.setAttr(eDay, "day-type", dayInfo.getDayType().value());
            CalendarXmlizer.setAttr(eDay, "is-transfer", dayInfo.isTransfer());
            dayInfo.getTransferDate().forEach(date -> CalendarXmlizer.setAttr(eDay, "transfer-date", date));
        }

        if (grayerWeekNoAppenderO.isPresent()) {
            grayerWeekNoAppenderO.get().append(eDay, localDate);
        }

        if (dayInfo.getNames().isNotEmpty() && (outLabels || dayInfo.isOverride())) {
            // TODO remove "name" from tag value
            String name = Option.when(!outLabels, dayInfo.getNames().first()).getOrElse(dayInfo.getNameO().get());

            eDay.setText(name);
            CalendarXmlizer.setAttr(eDay, "holiday-name", name);
        }

        rootElement.addContent(eDay);
    }

    public Element getElement() {
        return rootElement;
    }
}
