package ru.yandex.calendar.logic.ics;

import java.io.ByteArrayOutputStream;

import ru.yandex.misc.lang.Utf8;
import ru.yandex.misc.parse.ByteReaderForParser;

/**
 * @author Stepan Koltsov
 */
public class IcsUtf8Refolder {

    private static class BytesReader extends ByteReaderForParser {
        BytesReader(byte[] bytes) {
            super(bytes);
        }

        BytesReader(byte[] bytes, int pos) {
            super(bytes, pos);
        }

        boolean consumeIcsSplitOptional() {
            BytesReader reader = new BytesReader(bytes, pos);

            if (!reader.nextIsAnyOf(new byte[] { '\r', '\n' })) {
                return false;
            }

            reader.consumeOptional((byte) '\r');
            reader.consumeOptional((byte) '\n');

            if (!reader.nextIsAnyOf(new byte[] { ' ', '\t' })) {
                return false;
            }

            reader.next();

            this.pos = reader.pos;
            return true;
        }
    }

    private static class BytesWriter {
        private final ByteArrayOutputStream os = new ByteArrayOutputStream();

        void write(byte b) {
            os.write(b);
        }

        byte[] result() {
            return os.toByteArray();
        }
    }

    public static byte[] refold(byte[] input) {
        BytesReader reader = new BytesReader(input);
        BytesWriter writer = new BytesWriter();

        while (reader.hasNext()) {
            byte b = reader.next();
            writer.write(b);

            int kind = Utf8.parseUtf8Byte(b);
            if (kind == Utf8.ASCII || kind == Utf8.INVALID || kind == Utf8.CONTINUATION) {
                continue;
            }

            int newlines = 0;
            for (int i = 0; i < kind - 1; ++i) {
                while (reader.consumeIcsSplitOptional()) {
                    ++newlines;
                }
                byte c = reader.next();
                writer.write(c);
                if (Utf8.parseUtf8Byte(c) != Utf8.CONTINUATION) {
                    break;
                }
            }
            for (int i = 0; i < newlines; ++i) {
                writer.write((byte) '\r');
                writer.write((byte) '\n');
                writer.write((byte) ' ');
            }
        }

        return writer.result();
    }

} //~
