package ru.yandex.calendar.logic.ics.exp;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventFields;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author akirakozov
 * @author gutman
 */
public class EventInstanceParameters {
    private final Instant startTs;
    private final Instant endTs;
    private final Option<Instant> occurrenceId;

    public EventInstanceParameters(InstantInterval interval, Option<Instant> occurrenceId) {
        this(interval.getStart(), interval.getEnd(), occurrenceId);
    }

    public EventInstanceParameters(Instant startTs, Instant endTs, Option<Instant> occurrenceId) {
        this.startTs = startTs;
        this.endTs = endTs;
        this.occurrenceId = occurrenceId;
    }

    public Instant getStartTs() {
        return startTs;
    }

    public Instant getEndTs() {
        return endTs;
    }

    public Option<Instant> getOccurrenceId() {
        return occurrenceId;
    }

    public InstantInterval getInterval() {
        return new InstantInterval(startTs, endTs);
    }

    public static EventInstanceParameters fromEvent(Event event) {
        Option<Instant> recurrenceId;
        // not set only in tests
        if (event.isFieldSet(EventFields.RECURRENCE_ID)) {
            recurrenceId = event.getFieldValueNullAsNone(EventFields.RECURRENCE_ID);
        } else {
            recurrenceId = Option.empty();
        }
        return new EventInstanceParameters(event.getStartTs(), event.getEndTs(), recurrenceId);
    }

    public static Function<Event, EventInstanceParameters> fromEventF() {
        return new Function<Event, EventInstanceParameters>() {
            public EventInstanceParameters apply(Event event) {
                return fromEvent(event);
            }
        };
    }

    public static Function<EventInstanceParameters, Instant> getStartTsF() {
        return new Function<EventInstanceParameters, Instant>() {
            public Instant apply(EventInstanceParameters p) {
                return p.getStartTs();
            }
        };
    }

}
