package ru.yandex.calendar.logic.ics.exp;

import java.util.Optional;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.calendar.logic.event.ExternalId;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public abstract class IcsEventGroup {
    public abstract ExternalId getExternalId();

    public abstract Optional<IcsEventGroupExportData> getExport();
    public abstract Instant getDate();

    @AllArgsConstructor
    public static class IcsEventGroupExport extends IcsEventGroup {
        private final IcsEventGroupExportData export;

        @Override
        public ExternalId getExternalId() {
            return export.getExternalId();
        }

        @Override
        public Optional<IcsEventGroupExportData> getExport() {
            return Optional.of(export);
        }

        @Override
        public Instant getDate() {
            return export.getLastModified();
        }
    }

    @AllArgsConstructor
    @Getter
    public static class IcsEventGroupMiss extends IcsEventGroup {
        private final ExternalId externalId;
        private final Instant date;

        @Override
        public Optional<IcsEventGroupExportData> getExport() {
            return Optional.empty();
        }
    }

    public static IcsEventGroup export(IcsEventGroupExportData data) {
        return new IcsEventGroupExport(data);
    }

    public static IcsEventGroup miss(ExternalId externalId, Instant lastModified) {
        if (lastModified == null) {
            throw new NullPointerException("lastModified is null for " + externalId.getRaw());
        }
        return new IcsEventGroupMiss(externalId, lastModified);
    }
}
