package ru.yandex.calendar.logic.ics.exp;

import java.util.HashMap;
import java.util.Map;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Settings;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsMethod;

/**
 * @author dbrylev
 */
public class IcsExportParameters {
    private final IcsExportMode mode;
    private final IcsMethod method;
    private final boolean includeIcs;
    private final Instant now;
    private final Option<Settings> settings;
    private final Map<Long, Long> eventIdToExtraId;

    public IcsExportParameters(IcsExportMode mode, IcsMethod method, boolean includeIcs, Instant now) {
        this(mode, method, includeIcs, now, Option.empty(), new HashMap<>());
    }

    public IcsExportParameters(IcsExportMode mode, IcsMethod method, boolean includeIcs, Instant now, Option<Settings> settings, Map<Long, Long> eventIdToExtraId) {
        this.mode = mode;
        this.method = method;
        this.includeIcs = includeIcs;
        this.now = now;
        this.settings = settings;
        this.eventIdToExtraId = eventIdToExtraId;
    }

    public IcsExportMode getMode() {
        return mode;
    }

    public IcsMethod getMethod() {
        return method;
    }

    public boolean includeIcs() {
        return includeIcs;
    }

    public Instant getNow() {
        return now;
    }

    public Option<Settings> getSettings() {
        return this.settings;
    }

    public Option<Long> getExtraId(long eventId) {
        return Option.ofNullable(eventIdToExtraId.get(eventId));
    }
}
