package ru.yandex.calendar.logic.ics.exp;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVEvent;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsMethod;

/**
 * @author Stepan Koltsov
 */
public class IcsSingleEventExportData {

    private final Instant mainEventLastModified;
    private final String externalId;

    public boolean isHeavy() {
        return this instanceof Heavy;
    }

    public IcsSingleEventExportData(Instant mainEventLastModified, String externalId) {
        this.mainEventLastModified = mainEventLastModified;
        this.externalId = externalId;
    }

    public static class Heavy extends IcsSingleEventExportData {
        private final IcsVEvent vevent;
        private final DateTimeZone tz;

        public Heavy(IcsVEvent vevent, Instant lastModified, DateTimeZone tz, String externalId) {
            super(lastModified, externalId);
            this.vevent = vevent;
            this.tz = tz;
        }

        public IcsCalendar toCalendar(IcsMethod method, boolean withFullTimezones) {
            IcsCalendar calendar = IcsCalendar.fromIcal4j(IcsEventExporter.createCommonCalendarPart(method));
            calendar = calendar.addComponent(withFullTimezones
                    ? IcsTimeZones.icsVTimeZoneForIdFull(getTz().getID())
                    : IcsTimeZones.icsVTimeZoneForIdForOutlook(getTz().getID()));

            calendar = calendar.addComponents(Cf.list(getVevent()));

            return calendar;
        }

        public IcsVEvent getVevent() {
            return vevent;
        }

        public DateTimeZone getTz() {
            return tz;
        }

    }

    public static class Light extends IcsSingleEventExportData {

        public Light(Instant lastModified, String externalId) {
            super(lastModified, externalId);
        }

    }


    public Instant getMainEventLastModified() {
        return mainEventLastModified;
    }

    public String getExternalId() {
        return externalId;
    }

    public Heavy heavy() {
        return (Heavy) this;
    }

    public IcsCalendar toCalendar(IcsMethod method, boolean withFullTimezones) {
        return heavy().toCalendar(method, withFullTimezones);
    }

    public static Function<IcsSingleEventExportData, IcsVEvent> getVeventF() {
        return new Function<IcsSingleEventExportData, IcsVEvent>() {
            public IcsVEvent apply(IcsSingleEventExportData d) {
                return d.heavy().vevent;
            }
        };
    }

    public static Function<IcsSingleEventExportData, Instant> getMainEventLastModifiedF() {
        return new Function<IcsSingleEventExportData, Instant>() {
            public Instant apply(IcsSingleEventExportData d) {
                return d.mainEventLastModified;
            }
        };
    }

    public static Function<IcsSingleEventExportData, DateTimeZone> getTzF() {
        return new Function<IcsSingleEventExportData, DateTimeZone>() {
            public DateTimeZone apply(IcsSingleEventExportData d) {
                return d.heavy().tz;
            }
        };
    }

    public static Function<IcsSingleEventExportData, String> getExternalIdF() {
        return new Function<IcsSingleEventExportData, String>() {
            public String apply(IcsSingleEventExportData d) {
                return d.externalId;
            }
        };
    }

    public static Function1B<IcsSingleEventExportData> isHeavyF() {
        return new Function1B<IcsSingleEventExportData>() {
            public boolean apply(IcsSingleEventExportData d) {
                return d.isHeavy();
            }
        };
    }

} //~
