package ru.yandex.calendar.logic.ics.exp;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.frontend.caldav.proto.facade.ExportOptions;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVTimeZone;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVToDo;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsMethod;

/**
 * @author akirakozov
 */
public class IcsSingleTodoItemExportData {
    private final IcsVToDo icsToDo;
    private final DateTimeZone tz;
    private final Instant lastModified;
    private final String externalId;

    public IcsSingleTodoItemExportData(IcsVToDo icsToDo, DateTimeZone tz, Instant lastModified, String externalId) {
        this.icsToDo = icsToDo;
        this.tz = tz;
        this.lastModified = lastModified;
        this.externalId = externalId;
    }

    public IcsCalendar toCalendar(ExportOptions options) {
        IcsCalendar calendar = IcsCalendar.fromIcal4j(IcsEventExporter.createCommonCalendarPart(IcsMethod.PUBLISH));

        if (options.getEtcGmtForTimezones().contains(tz.getID())) {
            IcsVTimeZone fixedTimezone = IcsTimeZones.icsVTimeZoneForUtcOffset(tz.getOffset(Instant.now()));
            return calendar
                    .addComponent(fixedTimezone)
                    .addComponent(icsToDo.withTzIdParametersValue(fixedTimezone.getTzId()));
        }
        calendar = calendar.addComponent(options.isWithFullTimezones()
                ? IcsTimeZones.icsVTimeZoneForIdFull(tz.getID())
                : IcsTimeZones.icsVTimeZoneForIdForOutlook(tz.getID()));

        calendar = calendar.addComponent(icsToDo);

        return calendar;
    }

    public Instant getLastModified() {
        return lastModified;
    }

    public IcsVToDo getIcsToDo() {
        return icsToDo;
    }

    public String getExternalId() {
        return externalId;
    }

    public static Function<IcsSingleTodoItemExportData, String> getExternalIdF() {
        return new Function<IcsSingleTodoItemExportData, String>() {
            public String apply(IcsSingleTodoItemExportData d) {
                return d.externalId;
            }
        };
    }
}
