package ru.yandex.calendar.logic.ics.feed;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.IcsFeed;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.db.q.SqlQueryUtils;

/**
 * @author akirakozov
 */
public class IcsFeedDao extends CalendarJdbcDaoSupport {

    @Autowired
    private GenericBeanDao genericBeanDao;

    @RunWithRandomTest
    public ListF<IcsFeed> findIcsFeeds(SqlCondition c) {
        String q = "SELECT * FROM ics_feed WHERE " + c.sql();

        if (skipQuery(c, q, c.args())) return Cf.list();

        return getJdbcTemplate().queryForList(q, IcsFeed.class, c.args());
    }

    public void saveIcsFeed(IcsFeed icsFeed) {
        genericBeanDao.insertBean(icsFeed);
    }

    @RunWithRandomTest(possible=EmptyResultDataAccessException.class)
    public IcsFeed findIcsFeedByLayerId(long layerId) {
        String q = "SELECT * FROM ics_feed WHERE layer_id = ?";
        return getJdbcTemplate().queryForObject(q, IcsFeed.class, layerId);
    }

    public void updateIcsFeed(IcsFeed icsFeedData) {
        genericBeanDao.updateBean(icsFeedData);
    }

    @RunWithRandomTest
    public void deleteIcsFeedByUid(ListF<PassportUid> uid) {
        String q = "DELETE FROM ics_feed WHERE uid " + SqlQueryUtils.inSet(uid);

        if (skipQuery(uid, q)) return;

        getJdbcTemplate().update(q);
    }

    @RunWithRandomTest
    public void updateFeedNextQueryTsByUid(PassportUid uid, Instant nextQueryTs) {
        String q = "UPDATE ics_feed SET next_query_ts = ? WHERE uid = ?";
        getJdbcTemplate().update(q, nextQueryTs, uid);
    }

    @RunWithRandomTest(possible=EmptyResultDataAccessException.class)
    public void deleteIcsFeedByLayerId(long layerId) {
        String q = "DELETE FROM ics_feed WHERE layer_id = ?";
        getJdbcTemplate().updateRow(q, layerId);
    }

}
