package ru.yandex.calendar.logic.ics.feed;

import java.util.stream.Stream;

import javax.annotation.PreDestroy;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.IcsFeed;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@AllArgsConstructor
public class MixedIcsFeedDownloader implements IcsFeedDownloader {
    private static final Logger logger = LoggerFactory.getLogger(MixedIcsFeedDownloader.class);

    private final PlainIcsFeedDownloader plainDownloader;
    private final ZoraIcsFeedDownloader zoraDownloader;
    private final String icsPlainFeedPattern;

    @PreDestroy
    public void destroy() {
        Stream.of(plainDownloader, zoraDownloader).forEach(HttpIcsFeedDownloader::destroy);
    }

    private HttpIcsFeedDownloader getDownloader(String url) {
        if (url.contains(icsPlainFeedPattern)) {
            logger.debug("Processing as internal url: {}", url);
            return plainDownloader;
        }
        logger.debug("Processing as external url: {}", url);
        return zoraDownloader;
    }

    @Override
    public byte[] downloadNow(String url) {
        return getDownloader(url).downloadNow(url);
    }

    @Override
    public Option<DownloadedFeed> downloadIfModified(IcsFeed feed) {
        return getDownloader(feed.getUrl()).downloadIfModified(feed);
    }
}
