package ru.yandex.calendar.logic.ics.feed;

import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

import ru.yandex.calendar.util.HttpClientConfiguration;

/**
 * @author Sergey Shinderuk
 */
public class PlainIcsFeedDownloader extends HttpIcsFeedDownloader {

    public PlainIcsFeedDownloader(HttpClientConfiguration conf) {
        super(makeHttpClient(conf));
    }

    private static HttpClient makeHttpClient(HttpClientConfiguration conf) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(conf.maxConnections);
        connectionManager.setMaxTotal(conf.maxConnections);

        RequestConfig params = RequestConfig.custom()
                .setConnectTimeout(conf.connectionTimeout)
                .setSocketTimeout(conf.socketTimeout)
                .setStaleConnectionCheckEnabled(true)
                .setMaxRedirects(conf.maxRedirects)
                .build();

        return HttpClientBuilder.create()
                .disableCookieManagement()
                .setDefaultRequestConfig(params)
                .setConnectionManager(connectionManager)
                .build();
    }

    @Override
    protected HttpGet makeRequest(String url) {
        return new HttpGet(url);
    }

    @Override
    protected HttpGet makeRequestNow(String url) {
        return makeRequest(url);
    }

    @Override
    protected String nameForLog() {
        return "direct";
    }
}
