package ru.yandex.calendar.logic.ics.feed;

import java.util.Optional;

import io.micrometer.core.instrument.MeterRegistry;
import lombok.AllArgsConstructor;
import lombok.val;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

@AllArgsConstructor
public class ZoraResponseInterceptor implements HttpResponseInterceptor {
    private final String metricName;
    private final MeterRegistry registry;

    @Override
    public void process(HttpResponse response, HttpContext context) {
        registry.counter(metricName).increment();

        val zoraQuotaCode = getHeaderValue(response, "X-Yandex-Http-Code").map(Integer::valueOf).filter(status -> status == 429);
        if (zoraQuotaCode.isPresent()) {
            val name = String.format("%s.quota", metricName);
            registry.counter(name).increment();
        }
    }

    private static Optional<String> getHeaderValue(HttpResponse response, String name) {
        return Optional.ofNullable(response.getFirstHeader(name)).map(Header::getValue);
    }
}
