package ru.yandex.calendar.logic.ics.imp;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.event.EventChangesFinder;
import ru.yandex.calendar.logic.event.EventWithRelations;
import ru.yandex.calendar.logic.event.MainEventWithRelations;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsVEventGroup;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsVTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVEvent;
import ru.yandex.calendar.util.dates.AuxDateTime;

/**
 * @author Stepan Koltsov
 * @see EventChangesFinder#getEventChangesInfo(ru.yandex.calendar.logic.event.EventInstanceForUpdate, ru.yandex.calendar.logic.event.model.EventData, ru.yandex.bolts.collection.Option, boolean)
 */
public class IcsEventChangesFinder {

    public static IcsEventChangesInfo changes(
            MainEventWithRelations existingMainEvent, IcsVEventGroup newEventGroup, IcsVTimeZones tzs)
    {
        ListF<EventWithRelations> deleteEvents = Cf.arrayList();
        ListF<IcsVEvent> createEvents = Cf.arrayList();
        Tuple2List<EventWithRelations, IcsVEvent> updateEvents = Cf.Tuple2List.arrayList();

        {
            ListF<EventWithRelations> existingMasterEvents = existingMainEvent.getMasterEvents();
            ListF<IcsVEvent> newMasterEvents = newEventGroup.getMasterEvents();

            if (existingMasterEvents.isNotEmpty() && newMasterEvents.isNotEmpty()) {
                updateEvents.add(existingMasterEvents.first(), newMasterEvents.first());
            } else if (existingMasterEvents.isNotEmpty()) {
                deleteEvents.add(existingMasterEvents.first());
            } else if (newMasterEvents.isNotEmpty()) {
                createEvents.add(newMasterEvents.first());
            }
        }

        {
            DateTimeZone tz = DateTimeZone.forID(existingMainEvent.getMainEvent().getTimezoneId());
            Function<Instant, LocalDate> dateF = AuxDateTime.instantDateF(tz);

            MapF<LocalDate, EventWithRelations> existingRecurrenceEventDates = existingMainEvent
                .getRecurrenceEvents()
                .toMapMappingToKey(e -> dateF.apply(e.getRecurrenceId().get()));

            MapF<LocalDate, IcsVEvent> newRecurrenceEventDates = newEventGroup
                .getRecurrenceEvents()
                .toMapMappingToKey(e -> dateF.apply(e.getRecurrenceId().get().getInstant(tzs)));

            ListF<LocalDate> dates = existingRecurrenceEventDates.keys().plus(newRecurrenceEventDates.keys()).stableUnique();

            for (LocalDate date : dates) {
                Option<EventWithRelations> existingEvent = existingRecurrenceEventDates.getO(date);
                Option<IcsVEvent> newEvent = newRecurrenceEventDates.getO(date);
                if (existingEvent.isPresent() && newEvent.isPresent()) {
                    updateEvents.add(existingEvent.get(), newEvent.get());
                } else if (existingEvent.isPresent()) {
                    deleteEvents.add(existingEvent.get());
                } else {
                    createEvents.add(newEvent.get());
                }
            }
        }

        return new IcsEventChangesInfo(deleteEvents, createEvents, updateEvents);
    }

} //~
