package ru.yandex.calendar.logic.ics.imp;

import java.util.Optional;

import lombok.AllArgsConstructor;
import lombok.Value;

@Value
@AllArgsConstructor
public class IcsImportCreateInfo {
    Optional<Long> eventId;
    IcsImportMails mails;

    public IcsImportCreateInfo(long eventId, IcsImportMails mails) {
        this.eventId = Optional.of(eventId);
        this.mails = mails;
    }

    public static IcsImportCreateInfo empty() {
        return new IcsImportCreateInfo(Optional.empty(), IcsImportMails.empty());
    }
}
