package ru.yandex.calendar.logic.ics.imp;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.sending.EventSendingInfo;
import ru.yandex.calendar.logic.sending.param.EventMessageParameters;
import ru.yandex.calendar.logic.sending.param.EventOnLayerChangeMessageParameters;
import ru.yandex.calendar.logic.sending.param.ReplyMessageParameters;

/**
 * @author dbrylev
 */
public class IcsImportMails {
    private final ListF<EventSendingInfo> updateMails;
    private final ListF<EventMessageParameters> eventMails;
    private final ListF<EventOnLayerChangeMessageParameters> notifyMails;
    private final ListF<ReplyMessageParameters> replyMails;

    public IcsImportMails(
            ListF<EventSendingInfo> updateMails,
            ListF<EventMessageParameters> eventMails,
            ListF<EventOnLayerChangeMessageParameters> notifyMails,
            ListF<ReplyMessageParameters> replyMails)
    {
        this.updateMails = updateMails;
        this.eventMails = eventMails;
        this.notifyMails = notifyMails;
        this.replyMails = replyMails;
    }

    public static IcsImportMails empty() {
        return new IcsImportMails(
                Cf.<EventSendingInfo>list(),
                Cf.<EventMessageParameters>list(),
                Cf.<EventOnLayerChangeMessageParameters>list(),
                Cf.<ReplyMessageParameters>list());
    }

    public static IcsImportMails eventMails(
            ListF<EventMessageParameters> eventMails)
    {
        return new IcsImportMails(
                Cf.<EventSendingInfo>list(), eventMails,
                Cf.<EventOnLayerChangeMessageParameters>list(), Cf.<ReplyMessageParameters>list());
    }

    public static IcsImportMails updateAndNotifyMails(
            ListF<EventSendingInfo> updateMails,
            ListF<EventOnLayerChangeMessageParameters> layerNotifyMails)
    {
        return new IcsImportMails(updateMails, Cf.<EventMessageParameters>list(), layerNotifyMails, Cf.<ReplyMessageParameters>list());
    }

    public static IcsImportMails replyAndNotifyMails(
            ListF<ReplyMessageParameters> replyMails,
            ListF<EventOnLayerChangeMessageParameters> notifyMails)
    {
        return new IcsImportMails(Cf.<EventSendingInfo>list(), Cf.<EventMessageParameters>list(), notifyMails, replyMails);
    }

    public static IcsImportMails notifyMails(ListF<EventOnLayerChangeMessageParameters> mails) {
        return new IcsImportMails(Cf.<EventSendingInfo>list(), Cf.<EventMessageParameters>list(), mails, Cf.<ReplyMessageParameters>list());
    }

    public IcsImportMails plusReplyAndNotifyMails(
            ListF<ReplyMessageParameters> reply, ListF<EventOnLayerChangeMessageParameters> notify)
    {
        return new IcsImportMails(
                updateMails, Cf.<EventMessageParameters>list(),
                notifyMails.plus(notify), replyMails.plus(reply));
    }

    public IcsImportMails plus(IcsImportMails mails) {
        return new IcsImportMails(
                updateMails.plus(mails.updateMails),
                eventMails.plus(mails.eventMails),
                notifyMails.plus(mails.notifyMails),
                replyMails.plus(mails.replyMails));
    }

    public ListF<EventSendingInfo> getUpdateMails() {
        return updateMails;
    }

    public ListF<EventMessageParameters> getEventMails() {
        return eventMails;
    }

    public ListF<EventOnLayerChangeMessageParameters> getNotifyMails() {
        return notifyMails;
    }

    public ListF<ReplyMessageParameters> getReplyMails() {
        return replyMails;
    }
}
