package ru.yandex.calendar.logic.ics.imp;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.layer.LayerType;
import ru.yandex.misc.lang.Validate;

/**
 * This method stores layer management information for ics import
 * @author akirakozov
 */
public class IcsLayerImportInfo {
    public static final IcsLayerImportInfo DEFAULT_USER_IF_CREATE = new IcsLayerImportInfo(
            LayerReference.defaultLayerIfCreate(), LayerType.USER);

    /**
     * layer management information.
     * ssytnik: not final: ics feed should be created earlier than
     * IcsImporter.identifyLayerId() is called, so we update reference.
     */
    LayerReference layerReference;
    final LayerType layerType;
    // Optional new layer name (if a new single layer will be created).
    // Applicable for LayerType.USER, GetCreateLayer/CreateNewLayer cases.
    private final Option<String> newLayerNameO;

    public IcsLayerImportInfo(LayerReference layerReference, LayerType layerType, Option<String> newLayerNameO) {
        Validate.isTrue(layerType == LayerType.USER || layerType == LayerType.FEED);
        if (layerReference.isCreate()) {
            Validate.some(newLayerNameO);
        }
        this.layerReference = layerReference;
        this.layerType = layerType;
        this.newLayerNameO = newLayerNameO;
    }

    public IcsLayerImportInfo(LayerReference layerReference, LayerType layerType) {
        this(layerReference, layerType, Option.<String>empty());
    }

    public IcsLayerImportInfo(long layerId, LayerType layerType) {
        this(LayerReference.id(layerId), layerType);
    }

    public LayerReference getLayerReference() {
        return layerReference;
    }

    public LayerType getLayerType() {
        return layerType;
    }

    public Option<String> getNewLayerNameO() {
        return newLayerNameO;
    }

    public void changeFeedCreateToFeedUpdate(long feedLayerId) {
        Validate.isTrue(layerReference.isCreateNew());
        Validate.isTrue(layerType == LayerType.FEED);
        layerReference = LayerReference.id(feedLayerId);
    }
}
