package ru.yandex.calendar.logic.ics.imp;

import org.jdom.Element;

import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 * @author Stepan Koltsov
 */
public class IcsTodoImportStats {

    private final int newTodoItemCount;
    private final int updatedTodoItemCount;
    private final int ignoredTodoItemCount;

    public IcsTodoImportStats(int newTodoItemCount, int updatedTodoItemCount, int ignoredTodoItemCount) {
        this.newTodoItemCount = newTodoItemCount;
        this.updatedTodoItemCount = updatedTodoItemCount;
        this.ignoredTodoItemCount = ignoredTodoItemCount;
    }

    public int getNewTodoItemCount() {
        return newTodoItemCount;
    }

    public int getUpdatedTodoItemCount() {
        return updatedTodoItemCount;
    }

    public int getIgnoredTodoItemCount() {
        return ignoredTodoItemCount;
    }

    public Element createTodosStatElem() {
        Element res = new Element("todos");
        CalendarXmlizer.setAttr(res, "added", newTodoItemCount);
        CalendarXmlizer.setAttr(res, "updated", updatedTodoItemCount);
        CalendarXmlizer.setAttr(res, "ignored", ignoredTodoItemCount);
        CalendarXmlizer.setAttr(res, "processed", newTodoItemCount + updatedTodoItemCount + ignoredTodoItemCount);
        return res;
    }

} //~
